<?php
/* -----------------------------------------------------------------
 * 	$Id: product_prices_advanced.php 796 2014-01-10 18:05:42Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

defined('_VALID_XTC') or die('Direct Access to this location is not allowed.');
require_once (DIR_FS_INC . 'xtc_get_tax_rate.inc.php');

require_once (DIR_FS_CATALOG . DIR_WS_CLASSES . 'class.xtcprice.php');

$xtPrice = new xtcPrice(DEFAULT_CURRENCY, $_SESSION['customers_status']['customers_status_id']);

if (PRICE_IS_BRUTTO == 'true') {
    $products_ekpprice = xtc_round($pInfo->products_ekpprice * ((100 + xtc_get_tax_rate($pInfo->products_tax_class_id)) / 100), PRICE_PRECISION);
    $products_uvpprice = xtc_round($pInfo->products_uvpprice * ((100 + xtc_get_tax_rate($pInfo->products_tax_class_id)) / 100), PRICE_PRECISION);
} else {
    $products_ekpprice = xtc_round($pInfo->products_ekpprice, PRICE_PRECISION);
    $products_uvpprice = xtc_round($pInfo->products_uvpprice, PRICE_PRECISION);
}
?>

<table width="100%" class="tablePrice">
    <tr>
        <td id="productsPrice" class="main"><?php echo TEXT_PRODUCTS_UVPPRICE; ?></td>
        <td id="productsPriceInput" class="main">
            <?php
            echo xtc_draw_input_field('products_uvpprice', $products_uvpprice);
            if (PRICE_IS_BRUTTO == 'true') {
                echo '&nbsp;' . TEXT_NETTO . '<b>' . $xtPrice->xtcFormat($pInfo->products_uvpprice, false) . '</b>  ';
            }
            ?>
    </tr>
    <tr>
        <td id="productsPrice" class="main"><?php echo TEXT_PRODUCTS_EKPPRICE; ?></td>
        <td id="productsPriceInput" class="main">
            <?php
            echo xtc_draw_input_field('products_ekpprice', $products_ekpprice);
            if (PRICE_IS_BRUTTO == 'true') {
                echo '&nbsp;' . TEXT_NETTO . '<b>' . $xtPrice->xtcFormat($pInfo->products_ekpprice, false) . '</b>  ';
            }
            ?>
    </tr>
    <tr>
        <td id="productsPrice" class="main"><?php echo TEXT_PRODUCTS_EXTRA_SHIPPING; ?></td>
        <td id="productsPriceInput" class="main"><?php echo xtc_draw_input_field('products_shipping_costs', $pInfo->products_shipping_costs); ?></td>
    </tr>
    <tr>
        <td id="productsPrice" class="main"><?php echo TEXT_PRODUCTS_MIN_ORDER; ?></td>
        <td id="productsPriceInput" class="main"><?php echo xtc_draw_input_field('products_minorder', $pInfo->products_minorder); ?></td>
    </tr>
    <tr>
        <td class="main"><?php echo TEXT_PRODUCTS_SPERRGUT; ?></td>
        <td class="main"><?php echo xtc_draw_pull_down_menu('products_sperrgut', $sperrgut_array, $pInfo->products_sperrgut); ?></td>
    </tr>
    <tr>
        <td id="productsPrice" class="main"><?php echo TEXT_PRODUCTS_DISCOUNT_ALLOWED; ?></td>
        <td id="productsPriceInput" class="main"><?php echo xtc_draw_input_field('products_discount_allowed', $pInfo->products_discount_allowed); ?></td>
    </tr>
</table>
